% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_list_fortify.R
\name{fortify.sim_list}
\alias{fortify.sim_list}
\title{Turn a collection of spatial interaction models into a data frame}
\usage{
\method{fortify}{sim_list}(
  model,
  data,
  flows = c("full", "destination", "attractiveness"),
  with_names = FALSE,
  normalisation = c("none", "origin", "full"),
  ...
)
}
\arguments{
\item{model}{a collection of spatial interaction models, a \code{sim_list}}

\item{data}{not used}

\item{flows}{\code{"full"} (default),  \code{"destination"} or \code{"attractiveness"}, see
details.}

\item{with_names}{specifies whether the extracted data frame includes
location names (\code{FALSE} by default), see details.}

\item{normalisation}{when \code{flows="full"}, the flows can be reported without
normalisation (\code{normalisation="none"}, the default value) or they can be
normalised, either to sum to one for each origin location
(\code{normalisation="origin"}) or to sum to one globally
(\code{normalisation="full"}).}

\item{...}{additional parameters, not used currently}
}
\value{
a data frame, see details
}
\description{
This function extracts from a collection of spatial interaction models
(represented by a \code{sim_list}) a data frame in a long format, with one flow
per row. This can be seen a collection oriented version of \code{\link[=fortify.sim]{fortify.sim()}}.
The resulting data frame is used by \code{\link[=autoplot.sim_list]{autoplot.sim_list()}} to produce summary
graphics.
}
\details{
The data frame produced by the method depends on the values of \code{flows} and to
a lesser extent on the value of \code{with_names}. In all cases, the data frame
has a \code{configuration} column that identify from which spatial interaction
model the other values have been extracted: this is the index of the model in
the original \code{sim_list}. Depending on \code{flows} we have the following
representations:
\itemize{
\item if \code{flows="full"}: this is the default case for which the full flow matrix
of each spatial interaction model is extracted. The data frame contains 4
columns:
\itemize{
\item \code{origin_idx}: identifies the origin location by its index from 1 to the number
of origin locations
\item \code{destination_idx}: identifies the destination location by its index from 1
to the number of destination locations
\item \code{flow}: the flow between the corresponding location. By default, flows
are normalised by origin location (when \code{normalisation="origin"}): the total
flows originating from each origin location is normalised to 1. If
\code{normalisation="full"}, this normalisation is global: the sum of all flows in
each model is normalised to 1. If \code{normalisation="none"} flows are not
normalised.
\item \code{configuration}: the spatial interaction model index
}
\item if \code{flows="destination"} or \code{flows="attractiveness"}, the data frame contains
3 or 4 columns:
\itemize{
\item \code{destination}: identifies the destination location by its index from 1
to the number of destination locations
\item \code{flow} or \code{attractiveness} depending on the value of \code{"flows"}: this contains
either the \code{\link[=destination_flow]{destination_flow()}} or the \code{\link[=attractiveness]{attractiveness()}} of the destination
location
\item \code{configuration}: the spatial interaction model index
\item \code{name}: the destination location names if \code{with_names=TRUE} (the column is
not present if \code{with_names=FALSE})
}
}

The normalisation operated when \code{flows="full"} can improve the readability
of the graphical representation proposed in \code{\link[=autoplot.sim_list]{autoplot.sim_list()}} when the
production constraints differ significantly from one origin location to another.
}
\examples{
\dontshow{if (requireNamespace("ggplot2", quietly = TRUE)) withAutoprint(\{ # examplesIf}
positions <- matrix(rnorm(10 * 2), ncol = 2)
distances <- as.matrix(dist(positions))
production <- rep(1, 10)
attractiveness <- c(2, rep(1, 9))
flows_1 <- blvim(distances, production, 1.5, 1, attractiveness)
flows_2 <- blvim(distances, production, 1.25, 2, attractiveness)
all_flows <- sim_list(list(flows_1, flows_2))
ggplot2::fortify(all_flows) ## somewhat similar to a row bind of sim_df results
ggplot2::fortify(all_flows, flows = "destination")
destination_names(all_flows) <- letters[1:10]
ggplot2::fortify(all_flows, flows = "attractiveness", with_names = TRUE)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=autoplot.sim_list]{autoplot.sim_list()}}
}
