% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim.R
\name{flows}
\alias{flows}
\title{Extract the flow matrix from a spatial interaction model object}
\usage{
flows(sim, ...)
}
\arguments{
\item{sim}{a spatial interaction model object}

\item{...}{additional parameters}
}
\value{
a matrix of flows between origin locations and destination locations
}
\description{
Extract the flow matrix from a spatial interaction model object
}
\examples{
distances <- french_cities_distances[1:10, 1:10] / 1000 ## convert to km
production <- log(french_cities$population[1:10])
attractiveness <- log(french_cities$area[1:10])
## rescale to production
attractiveness <- attractiveness / sum(attractiveness) * sum(production)
model <- static_blvim(distances, production, 1.5, 1 / 500, attractiveness)
flows(model)
}
\seealso{
\code{\link[=flows_df]{flows_df()}} for a data frame version of the flows,
\code{\link[=destination_flow]{destination_flow()}} for destination flows.
}
