% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.blended}
\alias{plot.blended}
\title{Blended survival curve based on short-term data and external information}
\usage{
\method{plot}{blended}(x, alpha = c(0.1, 0.05), ...)
}
\arguments{
\item{x}{A blended survival curve object obtain from \code{\link[=blendsurv]{blendsurv()}}}

\item{alpha}{A vector specifying the opacity of ribbon for the blended curve and other curves}

\item{...}{Additional arguments}
}
\value{
A \pkg{ggplot2} object
}
\description{
Blended survival curve based on short-term data and external information
}
\examples{
\dontshow{if (rlang::is_installed("survHEhmc")) withAutoprint(\{ # examplesIf}
library(survHE)

## trial data
data("TA174_FCR", package = "blendR")

## externally estimated data
data_sim <- ext_surv_sim(t_info = 144,
                         S_info = 0.05,
                         T_max = 180)

obs_Surv <- fit.models(formula = Surv(death_t, death) ~ 1,
                       data = dat_FCR,
                       distr = "exponential",
                       method = "hmc")

ext_Surv <- fit.models(formula = Surv(time, event) ~ 1,
                       data = data_sim,
                       distr = "exponential",
                       method = "hmc")

blend_interv <- list(min = 48, max = 150)
beta_params <- list(alpha = 3, beta = 3)

ble_Surv <- blendsurv(obs_Surv, ext_Surv, blend_interv, beta_params)

plot(ble_Surv)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=blendsurv]{blendsurv()}}
}
