% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_surv.R
\name{make_surv_methods}
\alias{make_surv_methods}
\alias{make_surv}
\alias{make_surv.survHE}
\alias{make_surv.flexsurvreg}
\alias{make_surv.inla}
\alias{make_surv.default}
\title{Create survival probabilities}
\usage{
make_surv(Surv, ...)

\method{make_surv}{survHE}(Surv, t, nsim = 100, ...)

\method{make_surv}{flexsurvreg}(Surv, t = NULL, nsim = 100, ...)

\method{make_surv}{inla}(Surv, t = NULL, nsim = 100, ...)

\method{make_surv}{default}(Surv, t = NULL, nsim = 100, ...)
}
\arguments{
\item{Surv}{survival analysis object}

\item{...}{Additional arguments}

\item{t}{Time points; vector}

\item{nsim}{Number of simulations; integer}
}
\value{
Matrix of survival probabilities
}
\description{
These function are version of the \code{\link[survHE:make.surv]{survHE::make.surv()}} function
from \pkg{survHE}. These are needed prior to blending.
}
\examples{
\dontshow{if (rlang::is_installed("survHEhmc")) withAutoprint(\{ # examplesIf}
library(survHE)

## trial data
data("TA174_FCR", package = "blendR")

## externally estimated data
data_sim <- ext_surv_sim(t_info = 144,
                         S_info = 0.05,
                         T_max = 180)

ext_Surv <- fit.models(formula = Surv(time, event) ~ 1,
                       data = data_sim,
                       distr = "exponential",
                       method = "hmc")

S_ext <- make_surv(ext_Surv, t = 1:100, nsim = 100)
\dontshow{\}) # examplesIf}
}
