% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.big_plsr}
\alias{predict.big_plsr}
\title{Predict method for big_plsr objects}
\usage{
\method{predict}{big_plsr}(
  object,
  newdata,
  ncomp = NULL,
  type = c("response", "scores", "prob", "class"),
  ...
)
}
\arguments{
\item{object}{A fitted PLS model produced by \code{\link[=pls_fit]{pls_fit()}}.}

\item{newdata}{Matrix or \code{bigmemory::big.matrix} with predictor values.}

\item{ncomp}{Number of components to use for prediction.}

\item{type}{Either "response" (default) or "scores".}

\item{...}{Unused, for compatibility with the generic.}
}
\value{
Predicted responses or component scores.
}
\description{
Predict method for big_plsr objects
}
\examples{
set.seed(123)
X <- matrix(rnorm(40), nrow = 10)
y <- X[, 1] - 0.5 * X[, 2] + rnorm(10, sd = 0.1)
fit <- pls_fit(X, y, ncomp = 2, scores = "r")
predict(fit, X, ncomp = 2)
}
