% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runRversions.R
\name{runRversions}
\alias{runRversions}
\title{Run code in several R versions}
\usage{
runRversions(
  scpt = NULL,
  expr = NULL,
  path = "C:/Program Files/R/",
  vrns = dir(path, pattern = "R-"),
  exec = "/bin/Rscript.exe"
)
}
\arguments{
\item{scpt}{File path to script. DEFAULT: NULL}

\item{expr}{Expression to be run. DEFAULT: NULL}

\item{path}{Location of R versions. DEFAULT: "C:/Program Files/R/"}

\item{vrns}{R Versions at path. DEFAULT: dir(path,pattern="R-")}

\item{exec}{Local path to Rscript. DEFAULT: "/bin/Rscript.exe"}
}
\value{
Results from each run
}
\description{
Run code / script in several local R versions
}
\examples{
tfile <- tempfile(fileext=".R")
cat(
'trace <- function() paste(sapply(sys.calls(),function(x)
                     strsplit(deparse(x),"(", fixed=TRUE)[[1]][1]), collapse=" -> ")
lower <- function(a) {message(trace(), " - msg with ", a+10); a}
upper <- function(b) lower(b+5)
upper(3)', file=tfile)

# Don't actually run with example testing
# out <- source(tfile) ; out$value # message + output 8
# runRversions(tfile)
# runRversions(expr=5+7)

}
\seealso{
\code{\link{help}}
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, May 2022
}
