% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aoe_border.R
\name{aoe_sample.aoe_border_result}
\alias{aoe_sample.aoe_border_result}
\title{Stratified Sampling from Border AoE Results}
\usage{
\method{aoe_sample}{aoe_border_result}(
  x,
  n = NULL,
  ratio = NULL,
  by = c("side", "class"),
  replace = FALSE,
  ...
)
}
\arguments{
\item{x}{An \code{aoe_border_result} object returned by \code{\link[=aoe_border]{aoe_border()}}.}

\item{n}{Total number of points to sample. If \code{NULL}, uses all available
points subject to the ratio constraint.}

\item{ratio}{Named numeric vector specifying target proportions. Names
should match the side names used in \code{aoe_border()} (e.g.,
\code{c(side_1 = 0.5, side_2 = 0.5)}) or use \code{c(core = 0.5, halo = 0.5)}
for distance-based sampling. Must sum to 1.}

\item{by}{Character. What to stratify by:
\itemize{
\item \code{"side"} (default): sample by side of the border
\item \code{"class"}: sample by core/halo classification
}}

\item{replace}{Logical. Sample with replacement? Default is \code{FALSE}.}

\item{...}{Additional arguments (ignored).}
}
\value{
An \code{aoe_border_result} object containing the sampled points.
}
\description{
Sample points from an \code{aoe_border_result} with control over side and/or
core/halo balance.
}
\examples{
library(sf)

# Create a border line
border <- st_as_sf(
  data.frame(id = 1),
  geometry = st_sfc(st_linestring(matrix(
    c(0, 0, 100, 100), ncol = 2, byrow = TRUE
  ))),
  crs = 32631
)

# Create points
pts <- st_as_sf(
  data.frame(id = 1:6),
  geometry = st_sfc(
    st_point(c(10, 20)),
    st_point(c(30, 10)),
    st_point(c(50, 80)),
    st_point(c(80, 40)),
    st_point(c(5, 5)),
    st_point(c(95, 95))
  ),
  crs = 32631
)

result <- aoe_border(pts, border, width = 20,
                     side_names = c("west", "east"))

# Equal sampling from each side
balanced <- aoe_sample(result, ratio = c(west = 0.5, east = 0.5))

# Sample by core/halo instead
by_class <- aoe_sample(result, ratio = c(core = 0.5, halo = 0.5),
                       by = "class")

}
