% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tables.R
\name{add_break_columns}
\alias{add_break_columns}
\title{Add break columns}
\usage{
add_break_columns(
  d,
  ...,
  .before = FALSE,
  omit_first = FALSE,
  omit_last = FALSE
)
}
\arguments{
\item{d}{data.frame or tibble}

\item{...}{Column name or tidyselect function. Select columns}

\item{.before}{insert break columns before selected columns (defaults to FALSE)}

\item{omit_first}{omit the first break column}

\item{omit_last}{omit the last break column}
}
\value{
data.frame or tibble
}
\description{
Add break columns
}
\examples{
d <- data.frame(x_n = 3, x_mean = 4,
            y_n = 5, y_mean = 6,
            z_n = 4, z_mean = 4)
# Unquoted variable names
add_break_columns(d, x_mean)

# Character vector
add_break_columns(d, c("y_n", "z_n"),  .before = TRUE)

# Tidyselect function (contains, starts_with, ends_with,
# matches, num_range, all_of, any_of)
# Insert columns after all columns
# ending with "_mean" except the last instance
add_break_columns(d,
                  dplyr::ends_with("_mean"),
                  omit_last = TRUE)
}
