% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/graph.R
\docType{methods}
\name{graph_create}
\alias{graph_create}
\alias{graph_create-method}
\alias{graph_create,data.frame-method}
\alias{graph_create,matrix-method}
\alias{graph_create,TimeIntervals-method}
\title{Create a Graph}
\usage{
graph_create(object, ...)

\S4method{graph_create}{data.frame}(
  object,
  type = c("interval", "stratigraphy"),
  direction = c("above", "below"),
  verbose = getOption("aion.verbose"),
  ...
)

\S4method{graph_create}{matrix}(
  object,
  type = c("interval", "stratigraphy"),
  direction = c("above", "below"),
  verbose = getOption("aion.verbose"),
  ...
)

\S4method{graph_create}{TimeIntervals}(
  object,
  type = c("interval", "stratigraphy"),
  verbose = getOption("aion.verbose"),
  ...
)
}
\arguments{
\item{object}{A \code{\linkS4class{TimeIntervals}} object or a two-columns \code{character}
\code{\link{matrix}} of edges (i.e. where each row specifies one relation element).}

\item{...}{Currently not used.}

\item{type}{A \code{\link{character}} string specifying the type of the graph to be
computed. It must be one of "\code{interval}" (the default) or "\code{stratigraphy}"
(see details). Any unambiguous substring can be given.}

\item{direction}{A \code{\link{character}} string specifying the direction of the
relations in \code{x}. It must be one of "\code{above}" (the default) or "\code{below}"
(see details). Any unambiguous substring can be given.
Only relevant if \code{type} is "\code{stratigraphy}".}

\item{verbose}{A \code{\link{logical}} scalar: should \R report extra information
on progress?}
}
\value{
An \pkg{igraph} graph object.
}
\description{
Creates an interval or a stratigraphic graph.
}
\details{
\describe{
\item{\code{interval}}{An interval graph is the graph showing intersecting
intervals on a line. As time is linear and not circular, an interval graph
contains no cycles with more than three edges and no shortcuts (it must be
a chordal graph).}
\item{\code{stratigraphy}}{A stratigraphic graph represents the directed
relationships between temporal units (archaeological deposits), from the
most recent to the oldest (Harris 1997). It can be formally defined as a
directed acyclic graph (DAG), in which each vertex represents a layer and
the edges represent stratigraphic relations.}
}
}
\note{
Experimental.

The \pkg{igraph} and \pkg{relations} packages need to be installed on your
machine.
}
\examples{
if (requireNamespace("igraph", quietly = TRUE) &&
    requireNamespace("relations", quietly = TRUE)) {
  ## Seven intervals
  int <- intervals(
    start = c(1, 2, 3, 6, 9, 13, 17),
    end = c(7, 4, 15, 14, 11, 18, 19),
    calendar = CE(),
    names = c("A", "B", "C", "D", "E", "F", "G")
  )

  ## Interval graph
  g <- graph_create(int, type = "interval")
  plot(g)

  ## Stratigraphic graph
  g <- graph_create(int, type = "strati")
  g <- graph_prune(g) # Remove redundant relations
  plot(g, layout = igraph::layout_with_sugiyama)
}
}
\references{
Harris, Edward C., 1997. \emph{Principles of Archaeological Stratigraphy}.
Seconde edition. Academic Press.
}
\seealso{
Other graph tools: 
\code{\link{graph_prune}()}
}
\author{
N. Frerebeau
}
\concept{graph tools}
