% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power.lwyy.test.R
\name{power.lwyy.test}
\alias{power.lwyy.test}
\title{Power calculations for one-sided two-sample test of LWYY model parameter.}
\usage{
power.lwyy.test(
  N = NULL,
  RR = NULL,
  bta1 = NULL,
  thta,
  L = NULL,
  tau = NULL,
  lam = NULL,
  alp = 0.05,
  pow = NULL,
  ar = 0.5,
  frailty.type = c("unblind", "blind"),
  lam.type = c("base", "pool")
)
}
\arguments{
\item{N}{Sample size.}

\item{RR, bta1}{Rate ratio, log-transform of rate ratio. Provide at most one of RR and bta1.}

\item{thta}{Variance of frailty parameter.}

\item{L}{Number of events.}

\item{tau}{Expected follow-up time.}

\item{lam}{Event rate. If lam.type = "base", it is the event rate for control. If lam.type = "pool", it is the pooled rate.}

\item{alp}{Two-sided alpha-level.}

\item{pow}{Target power.}

\item{ar}{Allocation ratio (Number control / Total)}

\item{frailty.type}{Indicates whether frailty variance is based on blinded information ("blind") or unblinded ("unblind"). Default "unblind".}

\item{lam.type}{Indicates whether event rate is based on control rate ("base") or pooled rate ("pool"). Ignored if lam = NULL. Default "base".}
}
\value{
An object of class "power.lwyytest", a list of arguments, including those computed, with \code{method} and note \code{elements}.
}
\description{
Function to compute power at one-sided Type I control level \code{alp/2} or
determine parameters to target given power to test the hypotheses
\code{H0: RR = 1} vs \code{HA: RR < 1} for the LWYY (Andersen-Gill with robust standard
errors) model.
}
\details{
An object of class "power.lwyytest" has the following components:

\itemize{
\item \code{method}: Description of the test.
\item \code{N}: Total sample size. \code{N = Nc + Nt}, where \code{Nc = ar * N} is the number on control and \code{Nt = (1-ar) * N} is the number on treatment.
\item \code{RR}, \code{RRCV}: Rate ratio powered for and critical value for rate ratio.
\item \code{bta1}, \code{bta1CV}: The log of \code{RR}, \code{RRCV}.
\item \code{thta}: The variance of the frailty parameter.
\item \code{thtap}: If frailty.type = "blind", the input variance from a blinded source.
\item \code{L}: Number of events. Note that all else being equal, an increase (decrease) in \code{N} requires a decrease (increase) in \code{L}.
\item \code{tau}, \code{lam0}: The mean follow-up time and control event rate. Note if \code{tau = 1}, then \code{lam0} may be interpreted as mean cumulative intensity on control.
\item \code{lamp}: If lam.type = "pool" and argument \code{lam} is not null, the input rate from a blinded source.
\item \code{alp}: \code{alp/2} is the one-sided Type I control level of the test \code{H0: RR = 1} vs \code{HA: RR < 1}.
\item \code{pow}: Power of the test.
\item \code{ar}: Allocation to control ratio \code{Nc/N}.
\item \code{note}: Set of key notes about the assessment.
}
}
\examples{

x = power.lwyy.test(N = 1000, RR = 0.8, thta = 1, L = 1000, tau = 0.9, alp = 0.05, ar = 0.5)
print(x)

x = power.lwyy.test(N = 1000, RR = 0.8, thta = 1, tau = 0.9, lam = 1.23, alp = 0.05, ar = 0.5)
print(x)

x = power.lwyy.test(N = 1000, RR = 0.8, thta = 1, tau = NULL, lam = 1.23, alp = 0.05, ar = 0.5)
print(x, digits = 3)

}
