% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assurance.R
\name{assurance}
\alias{assurance}
\title{Assurance (expected power) for LWYY}
\usage{
assurance(
  N,
  bta1,
  bta1_sd,
  thta,
  tau,
  lam,
  alp = 0.05,
  ar = 0.5,
  ns = 1000,
  method = c("integration", "montecarlo"),
  frailty.type = c("unblind", "blind"),
  lam.type = c("base", "pool"),
  thtawarning = FALSE
)
}
\arguments{
\item{N}{Sample size.}

\item{bta1}{log-transform of rate ratio.}

\item{bta1_sd}{assumed standard deviation of log(rate ratio)}

\item{thta}{Variance of frailty parameter. If frailty.type = "blind", assumes thta derives from pooled model; if frailty.type = "unblind" assumes thta is from correctly specified model. Default "unblind".}

\item{tau}{Expected follow-up time.}

\item{lam}{Event rate. If lam.type = "pool", assumes lam is pooled rate; if lam.type = "base", assumes lam is baseline control event rate. Default "base".}

\item{alp}{Two-sided alpha-level.}

\item{ar}{Allocation ratio (Number control / Total).}

\item{ns}{Maximum number of subintervals (if method = "integration") or Number of draws from prior distribution (if method = "montecarlo").}

\item{method}{Whether to numerically solve ("integration") or estimate by random draws ("montecarlo"). Defaults to numerical.}

\item{frailty.type}{Indicates whether frailty variance is based on blinded information ("blind") or unblinded ("unblind"). Default "unblind".}

\item{lam.type}{Indicates whether event rate is based on control rate ("base") or pooled rate ("pool"). Default "base".}

\item{thtawarning}{If TRUE indicates how many estimates of theta were negative before setting to 0. Default FALSE.}
}
\value{
The assurance given the input assumptions.
}
\description{
Function to compute assurance given fixed sample size N and follow-up tau, under input assumptions. Assumes a log-normal prior distribution.
Here assurance is taken to mean probability to achieve statistical significance (p-value < alp).
}
\details{
If working with a blinded estimate of frailty variance (i.e. misspecified model), it is recommended to use frailty.type = "blind" and lam.type = "pool".
In which case the frailty variance (i.e. model with treatment effect) is derived using thta and the quantile drawn from the prior distribution of the log-rate ratio.
If working with an estimate of frailty variance, should use frailty.type = "unblind" instead.

Function assumes a rate ratio < 1 is favourable to treatment.
}
\examples{

assurance(N = 500, bta1 = log(0.8), bta1_sd = 1, thta = 2, tau = 1, lam = 1.1, alp = 0.05,
          ns = 100000)


if (require("dplyr") & require("tidyr")) {

  assumptions = tibble(alp = 0.05) \%>\%
  crossing(
    N = c(500, 1000),
    RR = c(0.6, 0.7, 0.8),
    bta1_sd = 1,
    thta = c(2, 3, 4),
    tau = c(0.8,0.9, 1.0),
    lam0 = c(3, 3.5)
  ) \%>\%
    mutate(pow = pow(N = N, bta1 = log(RR), thta = thta, tau = tau, lam = lam0, alp = alp)) \%>\%
    mutate(
      assurance_in_blind = assurance(N = N, bta1 = log(RR), bta1_sd = bta1_sd, thta = thta,
                                     tau = tau, lam = lam0, alp = alp, ns = 1000,
                                     frailty.type = "blind", lam.type = "pool")
    ) \%>\%
    mutate(
      assurance_mc_blind = assurance(N = N, bta1 = log(RR), bta1_sd = bta1_sd, thta = thta,
                                     tau = tau, lam = lam0, alp = alp, ns = 1000,
                                     method = "monte",
                                     frailty.type = "blind", lam.type = "pool")
    ) \%>\%
    mutate(
      assurance_in_unblind = assurance(N = N, bta1 = log(RR), bta1_sd = bta1_sd, thta = thta,
                                       tau = tau, lam = lam0, alp = alp, ns = 1000)
    ) \%>\%
    mutate(
      assurance_mc_unblind = assurance(N = N, bta1 = log(RR), bta1_sd = bta1_sd, thta = thta,
                                       tau = tau, lam = lam0, alp = alp, ns = 1000)
    )

  assumptions \%>\% data.frame()

}
}
