% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{semiorthogonalize}
\alias{semiorthogonalize}
\title{Internal function: Semiorthogonal-type transformation of X2 to Z2}
\usage{
semiorthogonalize(Z2s, X2, Delta2, SVD = TRUE, postmult = FALSE)
}
\arguments{
\item{Z2s}{Matrix for which we take negative square root in
\eqn{X2 * Delta2 * Z2s^{1/2}}.}

\item{X2}{Design matrix of auxiliary regressors to be transformed to Z2}

\item{Delta2}{Scaling matrix such that diagonal of
\eqn{\bar{\Delta}_2 \bar{X}_2^{\top} \bar{M}_1 \bar{X}_2 \Delta_{2}} is one
(ignored scaling by \eqn{n} because not needed in code).
See \insertCite{deluca2018glm;textual}{WALS}}

\item{SVD}{If \code{TRUE}, uses \code{\link[base]{svd}} to compute eigendecomposition
of \code{Z2s}, otherwise uses \code{\link[base]{eigen}}.}

\item{postmult}{If \code{TRUE}, then it uses
\eqn{Z2s^{-1/2} = T \Lambda^{-1/2} T^{\top}}, where \eqn{T} contains
the eigenvectors of \eqn{Z2s} in its columns and \eqn{\Lambda} the corresponding
eigenvalues. If \code{FALSE} it uses \eqn{Z2s^{-1/2} = T \Lambda^{-1/2}}.}
}
\description{
Uses the matrix Z2s (called \eqn{\bar{\Xi}} in eq. (9) of
\insertCite{deluca2018glm;textual}{WALS}) to transform \eqn{\bar{X}_2} to
\eqn{\bar{Z}_2}, i.e. to perform \eqn{\bar{Z}_2 = \bar{X}_2 \bar{\Delta}_2 \bar{\Xi}^{-1/2}}.
For WALS in the linear regression model, the variables do not have a "bar".
}
\section{On the "semiorthogonal-type" transformation}{

For WALS GLM (and WALS in the linear regression model),
the transformation is semiorthogonal (ignored scaling by \eqn{n} for clarity
and because it is not needed in the code)
in the sense that \eqn{\bar{M}_{1} \bar{Z}_{2}} is semiorthogonal since
\deqn{\bar{Z}_{2}^{\top} \bar{M}_1 \bar{Z}_{2} =
(\bar{Z}_{2}^{\top} \bar{M}_1) (\bar{M}_{1} \bar{Z}_{2}) = I_{k_2},}
where \eqn{\bar{M}_1} is an idempotent matrix.

For WALS in the NB2 regression model, \eqn{\bar{M}_{1} \bar{Z}_{2}} is not
semiorthogonal anymore due to the rank-1 perturbation in \eqn{\bar{M}_1} which
causes \eqn{\bar{M}_1} to not be idempotent anymore, see
the section "Transformed model" in \insertCite{huynhwalsnb;textual}{WALS}.
}

\section{On the use of \code{postmult = TRUE}}{

The transformation of the auxiliary regressors \eqn{Z_2} for linear WALS in
eq. (12) of \insertCite{magnus2016wals;textual}{WALS} differs from the
transformation for WALS GLM (and WALS NB) in eq. (9) of
\insertCite{deluca2018glm;textual}{WALS}:

In \insertCite{magnus2016wals;textual}{WALS} the transformed auxiliary
regressors are

\deqn{Z_{2} = X_2 \Delta_2 T \Lambda^{-1/2},}

where \eqn{T} contains the eigenvectors of
\eqn{\Xi = \Delta_2 X_{2}^{\top} M_{1} X_{2} \Delta_2} in the columns and
\eqn{\Lambda} the respective eigenvalues. This definition is used when
\code{postmult = FALSE}.

In contrast, \insertCite{deluca2018glm;textual}{WALS} defines

\deqn{Z_2 = X_2 \Delta_2 T \Lambda^{-1/2} T^{\top},}

where we ignored scaling by \eqn{n} and the notation with "bar" for easier
comparison. This definition is used when \code{postmult = TRUE} and is
strongly preferred for \code{\link[WALS]{walsGLM}} and \code{\link[WALS]{walsNB}}.

See \insertCite{huynhwals;textual}{WALS} for more details.
}

\references{
\insertAllCited{}
}
