% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache.R
\name{FileCache}
\alias{FileCache}
\title{File Cache}
\description{
File-based persistent cache using RDS files
}
\section{Super class}{
\code{\link[VectrixDB:BaseCache]{VectrixDB::BaseCache}} -> \code{FileCache}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-FileCache-new}{\code{FileCache$new()}}
\item \href{#method-FileCache-get}{\code{FileCache$get()}}
\item \href{#method-FileCache-set}{\code{FileCache$set()}}
\item \href{#method-FileCache-delete}{\code{FileCache$delete()}}
\item \href{#method-FileCache-exists}{\code{FileCache$exists()}}
\item \href{#method-FileCache-clear}{\code{FileCache$clear()}}
\item \href{#method-FileCache-size}{\code{FileCache$size()}}
\item \href{#method-FileCache-cleanup_expired}{\code{FileCache$cleanup_expired()}}
\item \href{#method-FileCache-clone}{\code{FileCache$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="VectrixDB" data-topic="BaseCache" data-id="delete_many"><a href='../../VectrixDB/html/BaseCache.html#method-BaseCache-delete_many'><code>VectrixDB::BaseCache$delete_many()</code></a></span></li>
<li><span class="pkg-link" data-pkg="VectrixDB" data-topic="BaseCache" data-id="get_many"><a href='../../VectrixDB/html/BaseCache.html#method-BaseCache-get_many'><code>VectrixDB::BaseCache$get_many()</code></a></span></li>
<li><span class="pkg-link" data-pkg="VectrixDB" data-topic="BaseCache" data-id="make_key"><a href='../../VectrixDB/html/BaseCache.html#method-BaseCache-make_key'><code>VectrixDB::BaseCache$make_key()</code></a></span></li>
<li><span class="pkg-link" data-pkg="VectrixDB" data-topic="BaseCache" data-id="set_many"><a href='../../VectrixDB/html/BaseCache.html#method-BaseCache-set_many'><code>VectrixDB::BaseCache$set_many()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FileCache-new"></a>}}
\if{latex}{\out{\hypertarget{method-FileCache-new}{}}}
\subsection{Method \code{new()}}{
Create a new FileCache
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FileCache$new(config = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{config}}{CacheConfig object}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FileCache-get"></a>}}
\if{latex}{\out{\hypertarget{method-FileCache-get}{}}}
\subsection{Method \code{get()}}{
Get value from cache
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FileCache$get(key)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{Cache key}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Value or NULL
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FileCache-set"></a>}}
\if{latex}{\out{\hypertarget{method-FileCache-set}{}}}
\subsection{Method \code{set()}}{
Set value in cache
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FileCache$set(key, value, ttl = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{Cache key}

\item{\code{value}}{Value to cache}

\item{\code{ttl}}{Time to live}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FileCache-delete"></a>}}
\if{latex}{\out{\hypertarget{method-FileCache-delete}{}}}
\subsection{Method \code{delete()}}{
Delete key from cache
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FileCache$delete(key)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{Cache key}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Logical success
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FileCache-exists"></a>}}
\if{latex}{\out{\hypertarget{method-FileCache-exists}{}}}
\subsection{Method \code{exists()}}{
Check if key exists
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FileCache$exists(key)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{Cache key}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Logical
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FileCache-clear"></a>}}
\if{latex}{\out{\hypertarget{method-FileCache-clear}{}}}
\subsection{Method \code{clear()}}{
Clear cache
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FileCache$clear()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FileCache-size"></a>}}
\if{latex}{\out{\hypertarget{method-FileCache-size}{}}}
\subsection{Method \code{size()}}{
Get cache size
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FileCache$size()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Integer
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FileCache-cleanup_expired"></a>}}
\if{latex}{\out{\hypertarget{method-FileCache-cleanup_expired}{}}}
\subsection{Method \code{cleanup_expired()}}{
Cleanup expired entries
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FileCache$cleanup_expired()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Integer count removed
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FileCache-clone"></a>}}
\if{latex}{\out{\hypertarget{method-FileCache-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FileCache$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
