% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04-fishery-statistics.R
\name{weight_by_catch}
\alias{weight_by_catch}
\title{Weight length frequencies by total catch}
\usage{
weight_by_catch(frequency, catch, length, a, b, silence_warnings = FALSE)
}
\arguments{
\item{frequency}{Numeric vector of observed length frequencies.}

\item{catch}{Total catch amount (in kg or tons).}

\item{length}{Numeric vector of lengths corresponding to frequencies.}

\item{a}{Coefficient of the length-weight relationship.}

\item{b}{Exponent of the length-weight relationship.}

\item{silence_warnings}{Logical. Suppress warning messages.}
}
\value{
Numeric vector of weighted frequencies.
}
\description{
Scales observed length frequencies based on total recorded catch using length-weight relationship.
}
\details{
Catch weighting is used to estimate the size composition of catches when only
sub-samples are measured for length frequency analysis.
}
\references{
IMARPE (2020). Protocolo Elaboración de la Tabla de Decisión para la determinación del Límite
Máximo Total Permisible por temporada de pesca en la pesquería del stock norte-centro de la
anchoveta peruana. IMP-DGIRP/AFDPERP, Edición: 05, Revisión 00, 40p.
}
