% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/goodness_of_fit_copula_models.R
\name{marginal_gof_copula}
\alias{marginal_gof_copula}
\title{Produce marginal GoF plot}
\usage{
marginal_gof_copula(
  marginal,
  observed,
  name,
  type,
  treat,
  return_data = FALSE,
  grid = NULL,
  ...
)
}
\arguments{
\item{marginal}{Estimated marginal distribution represented by a list with
three elements in the following order: the estimated cdf, pdf, and inverse
cdf.}

\item{observed}{Observed values. These are used for the histogram.}

\item{name}{Name of the endpoint (used in the plot title).}

\item{type}{Type of endpoint: \code{"ordinal"} or \code{"continuous"}}

\item{treat}{Value for the treatment indicator.}

\item{return_data}{(boolean) Return the data used in the goodness-of-fit plot
(without the plot itself). This is useful when the user wants to customize the
plots, e.g., using \code{ggplot2}. See Details.}

\item{grid}{(numeric) vector of values for the endpoint at which the
model-based density is computed.}

\item{...}{Extra arguments passed onto \code{\link[=plot]{plot()}} or \code{\link[=hist]{hist()}} for an ordinal
and continuous endpoint, respectively.}
}
\description{
Produce marginal GoF plot
}
\section{Return Plotting Data}{
If \code{return_data} is \code{TRUE}, this function will return a data frame that can be
used to create customized plots. The following variables are present in the
returned data frame:
\itemize{
\item \code{observed}: The empirical proportions (\code{type = "ordinal"}). \code{NA} for
\code{type = "continuous"}.
\item \code{upper_ci}, \code{lower_ci}: Upper limit of the 95\% confidence interval for the empirical
proportions. Defaults to \code{NA} if \code{type = "continuous"}.
\item \code{value}: Value for the continuous or ordinal variable.
\item \code{model_based}: Estimated model-based density (\code{type = "continuous"}) or
proportions (\code{type = "ordinal"})
}
}

\seealso{
\code{\link[=plot.vine_copula_fit]{plot.vine_copula_fit()}}
}
