% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NormalCirculant.R
\name{NormalCirculant}
\alias{NormalCirculant}
\title{Multivariate normal with Circulant variance matrix.}
\description{
Provides methods for the Normal-Circulant (NCt) distribution, which for a random vector \code{z} of length \code{N} is defined as

\if{html}{\out{<div class="sourceCode">}}\preformatted{z ~ NCt(uacf)   <=>   z ~ Normal(0, toeplitz(acf)),
}\if{html}{\out{</div>}}

where \code{uacf} are the \code{Nu = floor(N/2)+1} unique elements of the autocorrelation vector \code{acf}, i.e.,

\if{html}{\out{<div class="sourceCode">}}\preformatted{acf = (uacf, rev(uacf[2:(Nu-1)]),   N even,
    = (uacf, rev(uacf[2:Nu])),      N odd.
}\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-NormalCirculant-new}{\code{NormalCirculant$new()}}
\item \href{#method-NormalCirculant-size}{\code{NormalCirculant$size()}}
\item \href{#method-NormalCirculant-logdens}{\code{NormalCirculant$logdens()}}
\item \href{#method-NormalCirculant-grad_full}{\code{NormalCirculant$grad_full()}}
\item \href{#method-NormalCirculant-clone}{\code{NormalCirculant$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-NormalCirculant-new"></a>}}
\if{latex}{\out{\hypertarget{method-NormalCirculant-new}{}}}
\subsection{Method \code{new()}}{
Class constructor.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NormalCirculant$new(N)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{N}}{Size of the NCt random vector.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{NormalCirculant} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-NormalCirculant-size"></a>}}
\if{latex}{\out{\hypertarget{method-NormalCirculant-size}{}}}
\subsection{Method \code{size()}}{
Get the size of the NCt random vector.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NormalCirculant$size()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Size of the NCt random vector.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-NormalCirculant-logdens"></a>}}
\if{latex}{\out{\hypertarget{method-NormalCirculant-logdens}{}}}
\subsection{Method \code{logdens()}}{
Log-density function.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NormalCirculant$logdens(z, uacf)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{z}}{Density argument. A vector of length \code{N} or an \verb{N x n_obs} matrix where each column is an \code{N}-dimensional observation.}

\item{\code{uacf}}{A vector of length \code{Nu = floor(N/2)} containing the first half of the autocorrelation (i.e., first row/column) of the Circulant variance matrix.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A scalar or vector of length \code{n_obs} containing the log-density of the NCt evaluated at its arguments.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-NormalCirculant-grad_full"></a>}}
\if{latex}{\out{\hypertarget{method-NormalCirculant-grad_full}{}}}
\subsection{Method \code{grad_full()}}{
Full gradient of log-density function.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NormalCirculant$grad_full(z, uacf, calc_dldz = TRUE, calc_dldu = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{z}}{Density argument.  A vector of length \code{N}.}

\item{\code{uacf}}{A vector of length \code{Nu = floor(N/2)} containing the first half of the autocorrelation (i.e., first row/column) of the Circulant variance matrix.}

\item{\code{calc_dldz}}{Whether or not to calculate the gradient with respect to \code{z}.}

\item{\code{calc_dldu}}{Whether or not to calculate the gradient with respect to \code{uacf}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list with elements:
\describe{
\item{\code{ldens}}{The log-density evaluated at \code{z} and \code{uacf}.}
\item{\code{dldz}}{The length-\code{N} gradient vector with respect to \code{z}, if \code{calc_dldz = TRUE}.}
\item{\code{dldu}}{The length-\code{Nu = floor(N/2)+1} gradient vector with respect to \code{uacf}, if \code{calc_dldu = TRUE}.}
}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-NormalCirculant-clone"></a>}}
\if{latex}{\out{\hypertarget{method-NormalCirculant-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NormalCirculant$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
