% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.softbart_probit}
\alias{predict.softbart_probit}
\title{Predict for SoftBart Probit Regression}
\usage{
\method{predict}{softbart_probit}(object, newdata, iterations = NULL, ...)
}
\arguments{
\item{object}{A \code{softbart_probit} object obtained as output of the \code{softbart_probit} function.}

\item{newdata}{A dataset to construct predictions on.}

\item{iterations}{The iterations get predictions on; includes all of iterations including burn-in and thinning iterations. Defaults to the saved iterations, running from \code{(num_burn + num_thin):(num_burn + num_thin * num_save)}.}

\item{...}{Other arguments passed to predict.}
}
\value{
A list containing 
\itemize{
  \item \code{mu}: samples of the nonparametric function for each observation, where \code{pnorm(mu)} is the success probability.
  \item \code{mu_mean}: posterior mean of mu.
  \item \code{p}: samples of the success probability \code{pnorm(mu)} for each observation.
  \item \code{p_mean}: posterior mean of \code{p}.
}
}
\description{
Computes predictions from a \code{softbart_probit} object for new data.
}
