% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/censoring_adminstrative.R
\name{recruitment_uniform}
\alias{recruitment_uniform}
\alias{admin_censoring_time}
\alias{admin_censoring_events}
\title{Add recruitment time to Dataset}
\usage{
recruitment_uniform(
  dat,
  recruitment_until,
  recruitment_from = 0,
  discrete = TRUE
)

admin_censoring_time(dat, followup, keep_non_recruited = FALSE)

admin_censoring_events(
  dat,
  events,
  keep_non_recruited = FALSE,
  on_incomplete = "ignore"
)
}
\arguments{
\item{dat}{a simulated dataset}

\item{recruitment_until}{time of end of recruitment}

\item{recruitment_from}{time of start of recruitment (defaults to 0)}

\item{discrete}{should the recruitment time be rounded to full days?}

\item{followup}{followup time}

\item{keep_non_recruited}{should patients recruited after end of study be kept}

\item{events}{number of events after which the dataset is analyzed}

\item{on_incomplete}{what to do if there are fewer events than planned "ignore","warn","stop"}
}
\value{
Returns the dataset with added recruitment times.

Returns the dataset with administrative censoring after \code{follwup}, adds the
attribute \code{followup} with the followup time to the dataset.

Returns the dataset with administrative censoring after \code{events} events, adds
the attribute \code{followup} with the followup time to the dataset.
}
\description{
Add recruitment time to Dataset

Apply Administrative Censoring After Fixed Time

Apply Administrative Censoring After Fixed Number of Events
}
\details{
The Dataset hast to include a column \code{rec_time} containing the recruitment
time as well as the columns with the event times \code{t} and a column with the
event indicator \code{evt}.

Times and event indicaotrs for patients recruited after followup are set to
\code{NA}.

The Dataset hast to include a column \code{rec_time} containing the recruitment
time as well as the columns with the event times \code{t} and a column with the
event indicator \code{evt}.

Times and event indicaotrs for patients recruited after followup are set to
\code{NA}.

If there are less events than planned for study end \code{on_incomplete} defines
what should be done. "ignore" simply returns the dataset with the maximum of
the observed times as followup. "warn" does the same but gives a warning.
"stop" stopps with an error.
}
\section{Functions}{
\itemize{
\item \code{recruitment_uniform()}: add recruitment time

\item \code{admin_censoring_time()}: apply administrative censoring after fixed time

\item \code{admin_censoring_events()}: apply administrative censoring after fixed number of events

}}
\examples{
dat <- data.frame(t=c(0, 1, 2), trt=c(FALSE, FALSE, TRUE))
recruitment_uniform(dat, 7, 0)
dat <- data.frame(
  t = 1:10,
  rec_time = rep(1:5, each=2),
  trt = rep(c(TRUE, FALSE), times=5),
  evt = rep(TRUE, times=10)
)
dat

admin_censoring_time(dat, 4)
admin_censoring_time(dat, 4, keep_non_recruited = TRUE)

dat_censored <- admin_censoring_time(dat, 5)
attr(dat_censored, "followup")
dat <- data.frame(
  t = 1:10,
  rec_time = rep(2*(1:5), each=2),
  trt = rep(c(TRUE, FALSE), times=5),
  evt = rep(TRUE, times=10)
)
dat

admin_censoring_events(dat, 4)
admin_censoring_events(dat, 4, keep_non_recruited = TRUE)

dat_censored <- admin_censoring_events(dat, 4)
attr(dat_censored, "followup")
}
