% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assay5.R
\name{.GetVariableFeatures}
\alias{.GetVariableFeatures}
\title{Returns the top variable features from a data frame of highly variable
feature annotations. Features are marked as variable if their value in
`label_column` is neither `NA` nor `FALSE`. When a ranking is provided via
`rank_column`, features are ordered accordingly.}
\usage{
.GetVariableFeatures(hvf_info, label_column, rank_column, nfeatures)
}
\arguments{
\item{hvf_info}{A `data.frame` containing highly variable feature 
annotations.}

\item{label_column}{A column in `hvf_info` indicating which features
are variable. A feature is considered variable if it's corresponding
value is not `NA` or `FALSE`.}

\item{rank_column}{A column in `hvf_info` indicating the rank of
each feature.}

\item{nfeatures}{The number of variable features to return.}
}
\description{
Returns the top variable features from a data frame of highly variable
feature annotations. Features are marked as variable if their value in
`label_column` is neither `NA` nor `FALSE`. When a ranking is provided via
`rank_column`, features are ordered accordingly.
}
\keyword{internal}
