% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{tianSigmaForComponent}
\alias{tianSigmaForComponent}
\title{Globally identify the covariance matrix of a C-component}
\usage{
tianSigmaForComponent(Sigma, internal, incoming, topOrder)
}
\arguments{
\item{Sigma}{the covariance matrix for the mixed graph G}

\item{internal}{an integer vector corresponding to the vertices of the
C-component that are in the bidirected equivalence classes (if the
graph is not-acyclic then these equivalence classes must be enlarged
by combining two bidirected components if there are two vertices, one
in each component, that are simultaneously on the same directed cycle).}

\item{incoming}{the parents of vertices in internal that are not in the set
internal themselves}

\item{topOrder}{a topological ordering of c(internal, incoming) with respect
to the graph G. For vertices in a strongly connected component the
ordering is allowed to be arbitrary.}
}
\value{
the new Sigma corresponding to the c-component
}
\description{
The Tian decomposition of a mixed graph G allows one to globally identify
the covariance matrices Sigma' of special subgraphs of G called c-components.
This function takes the covariance matrix Sigma corresponding to G and
a collection of node sets which specify the c-component, and returns the
Sigma' corresponding to the c-component.
}
