% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ancestralID.R
\name{getMaxFlow}
\alias{getMaxFlow}
\title{Size of largest HT system Y satisfying the HTC for a node v except perhaps
having |getParents(v)| < |Y|.}
\usage{
getMaxFlow(L, O, allowedNodes, biNodes, inNodes, node)
}
\arguments{
\item{L}{Adjacency matrix for the directed part of the path
diagram/mixed graph; an edge pointing from i to j is encoded as L[i,j]=1 and
the lack of an edge between i and j is encoded as L[i,j]=0. There should be
no directed self loops, i.e. no i such that L[i,i]=1.}

\item{O}{Adjacency matrix for the bidirected part of the path diagram/mixed
graph. Edges are encoded as for the L parameter. Again there should be no
self loops. Also this matrix will be coerced to be symmetric so it is only
necessary to specify an edge once, i.e. if O[i,j]=1 you may, but are not
required to, also have O[j,i]=1.}

\item{allowedNodes}{the set of allowed nodes.}

\item{biNodes}{the set of nodes in the subgraph G which are part of the
bidirected part.}

\item{inNodes}{the nodes of the subgraph G which are not in the bidirected
part but are a parent of some node in the bidirected component.}

\item{node}{the node (as an integer) for which the maxflow the largest half
trek system}
}
\value{
See title.
}
\description{
For an input mixed graph H, constructs the Gflow graph as described in Foygel
et al. (2012) for a subgraph G of H. A max flow algorithm is then run on
Gflow to determine the largest half-trek system in G to a particular node's
getParents given a set of allowed nodes. Here G should consist of a bidirected
part and nodes which are not in the bidirected part but are a parent of some
node in the bidirected part. G should contain the node for which to compute
the max flow.
}
\references{
Foygel, R., Draisma, J., and Drton, M.  (2012) Half-trek criterion for
generic identifiability of linear structural equation models.
\emph{Ann. Statist.} 40(3): 1682-1713.
}
