% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_metrics.R
\name{compute_metrics}
\alias{compute_metrics}
\title{Posterior-Predictive Metrics for Sca-MCMC Fit}
\usage{
compute_metrics(fit, y, X)
}
\arguments{
\item{fit}{Object returned by `sca_mcmc` (must contain `beta_chain` and `family`).}

\item{y}{Observed response vector (length n).}

\item{X}{n x p design matrix used for the fit.}
}
\value{
A data.frame with columns: R2, RMSE, AIC, BIC.
}
\description{
Computes R2, RMSE, AIC and BIC after discarding the first 50% of every chain
as burn-in. Predictive expectations are obtained by plugging the posterior
mean coefficients into the appropriate inverse-link function.
}
\examples{
set.seed(123)
X <- matrix(rnorm(100 * 3), 100, 3)
beta <- c(0.5, -0.2, 0.1)
y <- rgamma(100, shape = 2, rate = exp(X \%*\% beta))
fit <- sca_mcmc(y, X, family = "gamma", method = "ScaII", iter = 1000)
vals <- compute_metrics(fit, y, X)
print(vals)

}
