% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/samHL.R
\name{predict.samHL}
\alias{predict.samHL}
\title{Prediction function for S3 class \code{"samHL"}}
\usage{
\method{predict}{samHL}(object, newdata, thol = 0, ...)
}
\arguments{
\item{object}{An object with S3 class \code{"samHL"}.}

\item{newdata}{Numeric test matrix with \code{n} rows and \code{d} columns.}

\item{thol}{Decision-value threshold used to convert scores to labels. The
default value is \code{0}.}

\item{\dots}{Additional arguments passed to methods; currently unused.}
}
\value{
\item{values}{
  Predicted decision values as an \code{n} by \code{length(lambda)} matrix.
}
\item{labels}{
  Predicted class labels (\code{-1}/\code{1}) as an \code{n} by
  \code{length(lambda)} matrix.
}
}
\description{
Predict decision values and class labels for test data.
}
\details{
The test matrix is rescaled using the training \code{X.min}/\code{X.ran},
truncated to \code{[0, 1]}, and expanded with the same spline basis used
during training.
}
\seealso{
\code{\link{samHL}}
}
