% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survival_cov_adj.R
\name{get_lm_input}
\alias{get_lm_input}
\alias{h_get_lm_input}
\alias{h_get_strat_lm_input}
\title{Get Linear Model Input Data}
\usage{
h_get_lm_input(df, model)

h_get_strat_lm_input(df_with_stratum, model)
}
\arguments{
\item{df}{(\code{data.frame}) Including the covariates needed for the \code{model}, as well as the derived outcome \code{O_hat}
and the \code{treatment} factor.}

\item{model}{(\code{formula}) The right-hand side only model formula.}

\item{df_with_stratum}{(\code{data.frame}) A data frame with an additional column for the stratum, as returned by
\code{\link[=h_strat_derived_outcome_vals]{h_strat_derived_outcome_vals()}}.}
}
\value{
A list containing for each element of the \code{treatment} factor a list with the
corresponding model matrix \code{X} and the response vector \code{y}. For the stratified version,
the model matrix \code{X} includes the \code{.stratum} column.
}
\description{
Prepare the input data for a linear model based on the provided data frame and model formula.
}
\section{Functions}{
\itemize{
\item \code{h_get_lm_input()}: Get the linear model input data for the overall data set.

\item \code{h_get_strat_lm_input()}: Get the linear model input data with attached stratum column.

}}
\keyword{internal}
