% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/copulas.R
\name{cgumbel}
\alias{cgumbel}
\title{Gumbel copula constructor}
\usage{
cgumbel(theta)
}
\arguments{
\item{theta}{Dependence parameter (\eqn{\theta >= 1}).}
}
\value{
A function of two arguments (u,v) returning log copula density.
}
\description{
Returns a function that computes the log density of the bivariate Gumbel copula,
intended to be used with \code{\link{dcopula}}.
}
\details{
The Gumbel copula density

\deqn{
c(u,v;\theta) = \exp\Big[-\big((-\log u)^\theta + (-\log v)^\theta\big)^{1/\theta}\Big] \cdot h(u,v;\theta),
}
where \eqn{h(u,v;\theta)} contains the derivative terms ensuring the function is a density.
}
\examples{
x <- c(0.5, 1); y <- c(0.2, 0.4)
d1 <- dnorm(x, 1, log = TRUE); d2 <- dbeta(y, 2, 1, log = TRUE)
p1 <- pnorm(x, 1); p2 <- pbeta(y, 2, 1)
dcopula(d1, d2, p1, p2, copula = cgumbel(1.5), log = TRUE)
}
\seealso{
\code{\link[=cgaussian]{cgaussian()}}, \code{\link[=cclayton]{cclayton()}}, \code{\link[=cfrank]{cfrank()}}
}
