% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MAUT.R
\name{apply.MAUT}
\alias{apply.MAUT}
\title{Apply Multi-Attribute Utility Theory (MAUT) Method}
\usage{
apply.MAUT(mat, weights, beneficial.vector, utility.functions, step.size = 1)
}
\arguments{
\item{mat}{is a matrix containing values for different properties of different alternatives}

\item{weights}{are the weights of each property in the decision-making process}

\item{beneficial.vector}{is a vector containing the column numbers of beneficial properties}

\item{utility.functions}{is a vector specifying the utility function for each criterion ('exp', 'step', 'quad', 'log', 'ln')}

\item{step.size}{is a numeric value used for the step utility function (default is 1)}
}
\value{
a matrix containing the calculated utility scores
}
\description{
Apply Multi-Attribute Utility Theory (MAUT) Method
}
\examples{
mat <- matrix(c(75.5, 95, 770, 187, 179, 239, 237, 420, 91), nrow = 3, byrow = TRUE)
weights <- c(0.3, 0.5, 0.2)
beneficial.vector <- c(1, 3)
utility.functions <- c("exp", "log", "quad")
step.size <- 1
result <- apply.MAUT(mat, weights, beneficial.vector, utility.functions, step.size)

}
