% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AHP.R
\name{apply.ANP}
\alias{apply.ANP}
\title{Apply Analytical Network Process (ANP) on data}
\usage{
apply.ANP(A, comparing.competitors, power)
}
\arguments{
\item{A}{the matrix containing information related to pairwise comparisons of
criteria}

\item{comparing.competitors}{the list of matrices related to pairwise comparisons
of competitors for each criteria}

\item{power}{the power value of the supermatrix}
}
\value{
the limiting super matrix
}
\description{
Apply Analytical Network Process (ANP) on data
}
\examples{
data <- read.csv(system.file("extdata", "AHP_input_file.csv", package = "RMCDA"), header=FALSE)
mat.lst <- read.csv.AHP.matrices(data)
mat.lst[[1]]->A
mat.lst[[2]]->comparing.competitors
apply.ANP(A, comparing.competitors, 2)
}
