% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{get_cache_info}
\alias{get_cache_info}
\alias{reset_cache}
\alias{set_cache}
\title{Working with cache}
\usage{
get_cache_info()

reset_cache()

set_cache(path = file.path(getwd(), ".cache"))
}
\arguments{
\item{path}{The path to the cache directory.
Defaults to the '.cache' folder in the current working directory.}
}
\value{
Invisibly returns the path to the cache directory
or a list containing:
\item{path}{The path to the cache directory.}
\item{files}{The number of files in the cache.}
}
\description{
Get information about the cache

Reset the cache

Set the cache directory
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
get_cache_info()
\dontshow{\}) # examplesIf}
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
reset_cache()
\dontshow{\}) # examplesIf}
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
set_cache()
\dontshow{\}) # examplesIf}
}
