#' Example data set used in tutorial
#'
#' This is an example simulated data frame generated by `simulateData()` with
#' 100 accountable entities, an average of 50 observations per entity, a marginal outcome rate
#' of 0.2, a median reliability of 0.7, and a regression coefficient of 0 for the covariate.
#'
#' @format A data frame with six variables:
#'  \code{entity}, \code{z}, \code{x1}, \code{lp}, \code{p}, \code{y}.
"example_df_1"


#' Example data set with a covariate used in tutorial
#'
#' This is an example simulated data frame generated by `simulateData()` with
#' 100 accountable entities, an average of 50 observations per entity, a marginal outcome rate
#' of 0.2, and a median reliability of 0.7, and a regression coefficient of log(1.5) for the covariate.
#'
#'
#' @format A data frame with six variables:
#'  \code{entity}, \code{z}, \code{x1}, \code{lp}, \code{p}, \code{y}.
"example_df_2"


#' Beta-Binomial reliability results for example data set used in tutorial
#'
#' This is the pre-computed reliability results used in the tutorial for the Beta-Binomial method.
#'
"tutorial_BB_results"


#' Beta-Binomial reliability results for example aggregated data set used in tutorial
#'
#' This is the pre-computed reliability results used in the tutorial for the Beta-Binomial method
#' applied to an aggregated data set.
#'
"tutorial_BB_agg_results"


#' Risk-adjusted profiling results for example data set used in tutorial
#'
#' This is the pre-computed profiling results used in the tutorial for the risk-adjusted example.
"tutorial_profiling_results"


#' Reliability results for example data set used in tutorial
#'
#' This is the pre-computed reliability results used in the tutorial for example 1.
"tutorial_reliability_results_1"


#' Reliability results for example data set with risk adjustment used in tutorial
#'
#' This is the pre-computed reliability results used in the tutorial for example 2.
"tutorial_reliability_results_2"


#' Colonoscopy follow-up data
#'
#' These data are from the Centers for Medicare and Medicaid Services (CMS). They contain the percentage of patients receiving appropriate recommendation for follow-up screening colonoscopy
#' in calendar year 2023.
#'
#'
#' \code{entity} indicates the accountable health care entity;
#' \code{p} indicates the follow-up rate;
#' \code{n} indicates the denominator count for the measure;
#' \code{x} indicates the numerator count for the measure.
#'
#' @format A data frame with five variables:
#'  \code{entity}, \code{p},
#'   \code{n}, \code{x}.
"colonoscopy"


#' Psychiatric 30-day, unplanned readmission data
#'
#' These data are from the Centers for Medicare and Medicaid Services (CMS) and show the percentage of patients who return to a hospital for an unplanned inpatient stay after discharge. Data are from 07/01/2021 to 06/30/2023
#'
#'
#' @format A data frame with six variables:
#'  \code{entity}, \code{category},
#'   \code{n}, \code{rate}, \code{rate.lwr}, \code{rate.upr}.
"psychreadmission"



