% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process.R
\name{clean_artifact}
\alias{clean_artifact}
\title{Automatically clean artifacts.}
\usage{
clean_artifact(
  data = data,
  MADWindow = 100,
  MADConstant = 2,
  MADPadding = c(200, 200),
  MahaConstant = 2,
  Method = "Robust",
  XandY = TRUE,
  Second = TRUE,
  MaxValueRun = 5,
  NAsAroundRun = c(2, 2),
  LogFile = NULL
)
}
\arguments{
\item{data}{A data frame object created from \code{ppl_select_recorded_eye}.}

\item{MADWindow}{A numeric value specifying the window size (in msec) to use
for the MAD calculation.}

\item{MADConstant}{A numeric value specifying the constant (a multiplier for
the third quartile) when determining MAD outlier status.}

\item{MADPadding}{A numeric vector of length two containing values (in
msec) to pad the identified artifact creating a window within which to
operate the cleanup.}

\item{MahaConstant}{A numeric value specifying the constant (a multiplier
for the third quartile) when determining Mahalanobis outlier status.}

\item{Method}{A character string ("Basic" or "Robust") indicating
which method to use for the distance calculation. Basic is a standard
Mahalanobis distance calculation based on covariance. Robust is also a
Mahalanobis distance, however, it is based on Minimum Covariance
Determinant (Rousseeuw and van Driessen, 1999) with reweighted covariance
(Pison et al., 2002). For more details, see \code{\link[robustbase]{covMcd}}.}

\item{XandY}{A logical value specifying whether to also use horizontal
velocity and acceleration in outlier detection.}

\item{Second}{A logical value specifying whether secondary cleaning should
be applied.}

\item{MaxValueRun}{A numeric value specifying the maximal run of existing
values flanked by NAs that could be targeted for removal.}

\item{NAsAroundRun}{A numeric vector of length two containing values (in
number of subsequent NA) to be used to identify straggler runs of data
that could be removed.}

\item{LogFile}{A character string indicating the file name (with extension)
of the log file to be created/written. The file keeps track of which events
have been cleaned. We suggest "ArtifactCleanupLog.rds".}
}
\value{
An object of type data table as described in \link[tibble]{tibble}.
}
\description{
\code{clean_artifact} performs two stage and distributional automated
clean-up of artifacts in the pupil and gaze coordinate data.
}
\examples{
# Load example data
data("Pupilex4")

# Writing log file to temporary folder for the example
dat <- clean_artifact(Pupilex4, MADWindow = 100, MADConstant = 2,
                      MADPadding = c(200, 200), MahaConstant = 2,
                      Method = "Robust", XandY = TRUE, Second = TRUE,
                      MaxValueRun = 5, NAsAroundRun = c(2,2),
                      LogFile = paste0(tempdir(),"/ArtifactCleanupLog.rds"))

# Please see the vignettes for detailed example usage.
# vignette("PupilPre_Cleanup", package="PupilPre")

}
\references{
Rousseeuw, P. J. and van Driessen, K. (1999) A fast algorithm
for the minimum covariance determinant estimator. Technometrics 41, 212–223.

Pison, G., Van Aelst, S., and Willems, G. (2002) Small Sample
Corrections for LTS and MCD, Metrika 55, 111–123.
}
