% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backtesting.R
\name{run_backtest}
\alias{run_backtest}
\title{Run Portfolio Backtest}
\usage{
run_backtest(
  prices,
  weights,
  initial_capital = 1e+05,
  name = "Strategy",
  verbose = FALSE,
  stop_loss = NULL,
  stop_monitoring_prices = NULL
)
}
\arguments{
\item{prices}{Price data (data.frame with Date column)}

\item{weights}{Weight matrix from weighting functions}

\item{initial_capital}{Starting capital (default: 100000)}

\item{name}{Strategy name for reporting}

\item{verbose}{Print progress messages (default: FALSE)}

\item{stop_loss}{Optional stop loss percentage as decimal}

\item{stop_monitoring_prices}{Optional daily prices for stop monitoring}
}
\value{
backtest_result object with performance metrics
}
\description{
Main backtesting engine that simulates portfolio performance over time.
Handles position tracking, transaction costs, and performance calculation.
}
\examples{
data("sample_prices_weekly")
momentum <- calc_momentum(sample_prices_weekly, lookback = 12)
selected <- filter_top_n(momentum, n = 10)
weights <- weight_equally(selected)
result <- run_backtest(sample_prices_weekly, weights)
}
