% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/databaseDiagnostics.R
\name{databaseDiagnostics}
\alias{databaseDiagnostics}
\title{Database diagnostics}
\usage{
databaseDiagnostics(cdm)
}
\arguments{
\item{cdm}{CDM reference}
}
\value{
A summarised result
}
\description{
phenotypeR diagnostics on the cdm object.

Diagnostics include:
* Summarise a cdm_reference object, creating a snapshot with the metadata of the cdm_reference object.
* Summarise the observation period table getting some overall statistics in a summarised_result object.
}
\examples{
\donttest{
library(PhenotypeR)

cdm <- mockPhenotypeR()

result <- databaseDiagnostics(cdm)

CDMConnector::cdmDisconnect(cdm = cdm)
}
}
