# PeruAPIs - Access Peruvian Data via Public APIs and Curated Datasets
# Version 0.1.0
# Copyright (c) 2025 Renzo Caceres Rossi
# Licensed under the MIT License.
# See the LICENSE file in the root directory for full license text.

# birds_peru_tbl_df

library(testthat)

# Test 1: Confirm the object is a tibble/data.frame
test_that("birds_peru_tbl_df is a tibble", {
  expect_s3_class(birds_peru_tbl_df, "tbl_df")
  expect_s3_class(birds_peru_tbl_df, "tbl")
  expect_s3_class(birds_peru_tbl_df, "data.frame")
})

# Test 2: Confirm it has exactly 6 columns
test_that("birds_peru_tbl_df has 6 columns", {
  expect_equal(length(birds_peru_tbl_df), 6)
})

# Test 3: Confirm it has exactly 1,914 rows
test_that("birds_peru_tbl_df has 1914 rows", {
  expect_equal(nrow(birds_peru_tbl_df), 1914)
})

# Test 4: Confirm column names are correct and in order
test_that("birds_peru_tbl_df has correct column names", {
  expect_named(birds_peru_tbl_df, c(
    "order_name", "family_name", "scientific_name",
    "english_name", "spanish_name", "status"
  ))
})

# Test 5: Confirm column types are correct
test_that("birds_peru_tbl_df columns have correct types", {
  expect_type(birds_peru_tbl_df$order_name, "character")
  expect_type(birds_peru_tbl_df$family_name, "character")
  expect_type(birds_peru_tbl_df$scientific_name, "character")
  expect_type(birds_peru_tbl_df$english_name, "character")
  expect_type(birds_peru_tbl_df$spanish_name, "character")
  expect_type(birds_peru_tbl_df$status, "character")
})

