% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildDrugEra.R
\name{buildDrugEra}
\alias{buildDrugEra}
\title{Build the \code{drug_era} table}
\usage{
buildDrugEra(cdm, collapseDays = 30L)
}
\arguments{
\item{cdm}{A \code{cdm_reference} object.}

\item{collapseDays}{Number of days that two exposures can be separated to be
collapsed in a single era.}
}
\value{
The lazy \code{drug_era} table.
}
\description{
Build the \code{drug_era} table
}
\examples{
\donttest{
library(omock)
library(OmopConstructor)
library(dplyr, warn.conflicts = TRUE)

cdm <- mockCdmFromDataset(datasetName = "GiBleed", source = "duckdb")

cdm$drug_era <- buildDrugEra(cdm = cdm)
cdm$drug_era |>
  glimpse()

}

}
