% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/olink_normalization.R
\name{norm_internal_subset}
\alias{norm_internal_subset}
\title{Internal subset normalization function}
\usage{
norm_internal_subset(
  ref_df,
  ref_samples,
  ref_name,
  ref_cols,
  not_ref_df,
  not_ref_samples,
  not_ref_name,
  not_ref_cols
)
}
\arguments{
\item{ref_df}{The reference dataset to be used in normalization (required).}

\item{ref_samples}{Character vector of sample identifiers to be used for
adjustment factor calculation in the reference dataset (required).}

\item{ref_name}{Project name of the reference dataset (required).}

\item{ref_cols}{Named list of column names in the reference dataset
(required).}

\item{not_ref_df}{The non-reference dataset to be used in normalization
(required).}

\item{not_ref_samples}{Character vector of sample identifiers to be used for
adjustment factor calculation in the non-reference dataset (required).}

\item{not_ref_name}{Project name of the non-reference dataset (required).}

\item{not_ref_cols}{Named list of column names in the non-reference dataset
(required).}
}
\value{
Tibble or ArrowObject with the normalized dataset.
}
\description{
This function performs subset normalization using a subset of the samples
from either or both reference and non-reference datasets. When all samples
from each dataset are used, the function performs intensity normalization.
}
\author{
Klev Diamanti
}
