% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PredictionQueries.R
\name{getPredictionPerformanceTable}
\alias{getPredictionPerformanceTable}
\title{Extract specific results table}
\usage{
getPredictionPerformanceTable(
  connectionHandler,
  schema,
  plpTablePrefix = "plp_",
  databaseTable = "database_meta_data",
  table = "attrition",
  modelDesignIds = NULL,
  performanceIds = NULL,
  evaluations = NULL
)
}
\arguments{
\item{connectionHandler}{A connection handler that connects to the database and extracts sql queries.  Create a connection handler via `ResultModelManager::ConnectionHandler$new()`.}

\item{schema}{The result database schema (e.g., 'main' for sqlite)}

\item{plpTablePrefix}{The prefix used for the patient level prediction results tables}

\item{databaseTable}{The name of the table with the database details (default 'database_meta_data')}

\item{table}{The table to extract (covariate_summary, attrition, prediction_distribution, threshold_summary, calibration_summary, evaluation_statistics or demographic_summary )}

\item{modelDesignIds}{(optional) restrict to the input modelDesignIds}

\item{performanceIds}{(optional) restrict to the input performanceIds}

\item{evaluations}{(optional) restrict to the type of evaluation (e.g., 'Test'/'Train'/'CV'/'Validation')}
}
\value{
Returns a data.frame with the specified table
}
\description{
This function extracts the specified table
}
\details{
Specify the connectionHandler, the resultDatabaseSettings, the table of interest and (optionally) a performanceId to filter to
}
\examples{
conDet <- getExampleConnectionDetails()

connectionHandler <- ResultModelManager::ConnectionHandler$new(conDet)

attrition <- getPredictionPerformanceTable(
  connectionHandler = connectionHandler, 
  schema = 'main',
  table = 'attrition'
)

}
\seealso{
Other Prediction: 
\code{\link{getFullPredictionPerformances}()},
\code{\link{getPredictionAggregateTopPredictors}()},
\code{\link{getPredictionCohorts}()},
\code{\link{getPredictionCovariates}()},
\code{\link{getPredictionDiagnosticTable}()},
\code{\link{getPredictionDiagnostics}()},
\code{\link{getPredictionHyperParamSearch}()},
\code{\link{getPredictionIntercept}()},
\code{\link{getPredictionLift}()},
\code{\link{getPredictionModelDesigns}()},
\code{\link{getPredictionOutcomes}()},
\code{\link{getPredictionPerformances}()},
\code{\link{getPredictionTargets}()},
\code{\link{getPredictionTopPredictors}()}
}
\concept{Prediction}
