% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OVL_derivates_1.R
\name{OVL_derivates_1}
\alias{OVL_derivates_1}
\title{Numerical derivatives of the overlap functional (normal vs. 2-component mixture).}
\usage{
OVL_derivates_1(
  mu1_hat,
  mu2_hat,
  sigma1_hat,
  sigma2_hat,
  pi2_hat,
  h,
  intersec,
  OVL_mix
)
}
\arguments{
\item{mu1_hat}{Numeric scalar. Estimated mean for the normal group.}

\item{mu2_hat}{Numeric vector of length 2. Estimated means for the mixture group.}

\item{sigma1_hat}{Numeric scalar. Estimated standard deviation for the normal group.}

\item{sigma2_hat}{Numeric vector of length 2. Estimated standard deviations for the mixture group.}

\item{pi2_hat}{Either a numeric scalar in [0,1] giving the mixing proportion of the first component in the
mixture, or a numeric vector of length 2 with elements summing to 1.}

\item{h}{Positive numeric scalar. Base step size for finite differences.}

\item{intersec}{Numeric vector. Intersection points used as cutpoints.}

\item{OVL_mix}{Function that evaluates the overlap-related expression at cutpoints.}
}
\value{
A list with components \code{deriv1}–\code{deriv7}.
}
\description{
Computes finite-difference approximations of the partial derivatives of the
overlap coefficient with respect to the parameters in the case where
the first group is modeled as a normal distribution and the second group as
a two-component Gaussian mixture.
}
\details{
This function is intended for internal use (delta-method variance estimation).
}
\keyword{internal}
