% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_intermediate_values.R
\name{extract_intermediate_values}
\alias{extract_intermediate_values}
\title{Extract intermediate values from text lines}
\usage{
extract_intermediate_values(list_input, lines, search_text)
}
\arguments{
\item{list_input}{List. The list to append extracted values to.}

\item{lines}{Character vector. The text lines to search within.}

\item{search_text}{Character. The pattern to search for.}
}
\value{
An updated list with appended values.
}
\description{
This function retrieves unique matches for a search pattern within text lines.
}
\examples{
InputPath <- system.file("extdata", package = "ORscraper")
files <- read_pdf_files(InputPath)
lines <- read_pdf_content(files[1])  # Example with the first file
NHC_Data <- NB_values <- dates <- textDiag <- c()
NHC_Data <- extract_intermediate_values(NHC_Data, lines, "NHC:")
NB_values <- extract_intermediate_values(NB_values, lines, "biopsia:")
dates <- extract_intermediate_values(dates, lines, "Fecha:")
textDiag <- extract_intermediate_values(textDiag, lines, "de la muestra:")

}
