% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ModAtanExp.r
\name{ModAtanExp}
\alias{ModAtanExp}
\alias{dmod.atan.exp}
\alias{pmod.atan.exp}
\alias{qmod.atan.exp}
\alias{rmod.atan.exp}
\alias{hmod.atan.exp}
\title{Modified Atan Exponential Distribution}
\usage{
dmod.atan.exp(x, alpha, beta, lambda, log = FALSE)
pmod.atan.exp(q, alpha, beta, lambda, lower.tail = TRUE, log.p = FALSE)
qmod.atan.exp(p, alpha, beta, lambda, lower.tail = TRUE, log.p = FALSE)
rmod.atan.exp(n, alpha, beta, lambda)
hmod.atan.exp(x, alpha, beta, lambda)
}
\arguments{
\item{x, q}{numeric vector of quantiles (x, q)}

\item{alpha}{positive numeric parameter}

\item{beta}{positive numeric parameter}

\item{lambda}{positive numeric parameter}

\item{log}{logical; if TRUE, returns log-density}

\item{lower.tail}{logical; if TRUE (default), probabilities are 
\eqn{P[X \le x]} otherwise, \eqn{P[X > x]}.}

\item{log.p}{logical; if TRUE, probabilities are given as log(p)}

\item{p}{numeric vector of probabilities (0 < p < 1)}

\item{n}{number of observations (integer > 0)}
}
\value{
\itemize{
  \item \code{dmod.atan.exp}: numeric vector of (log-)densities
  \item \code{pmod.atan.exp}: numeric vector of probabilities
  \item \code{qmod.atan.exp}: numeric vector of quantiles
  \item \code{rmod.atan.exp}: numeric vector of random variates
  \item \code{hmod.atan.exp}: numeric vector of hazard values
}
}
\description{
Provides density, distribution, quantile, random generation,
and hazard functions for the Modified Atan Exponential distribution.
}
\details{
The Modified Atan Exponential distribution is parameterized by the parameters
\eqn{\alpha > 0}, \eqn{\beta > 0}, and \eqn{\lambda > 0}.


The Modified Atan Exponential distribution has CDF:

\deqn{
F(x; \alpha, \beta, \lambda) =
\left[\frac{2}{\pi} \arctan \left\{\beta x e^{\alpha x}\right\}\right]
^\lambda ; x \geq 0.
}

where \eqn{\alpha}, \eqn{\beta}, and \eqn{\lambda} are the parameters.

The following functions are included:
\itemize{
  \item \code{dmod.atan.exp()} — Density function
  \item \code{pmod.atan.exp()} — Distribution function
  \item \code{qmod.atan.exp()} — Quantile function
  \item \code{rmod.atan.exp()} — Random generation
  \item \code{hmod.atan.exp()} — Hazard function
}
}
\examples{
x <- seq(0.1, 10, 0.2)
dmod.atan.exp(x, 0.1, 0.2, 1.2)
pmod.atan.exp(x, 0.1, 0.2, 1.2)
qmod.atan.exp(0.5, 0.1, 0.2, 1.2)
rmod.atan.exp(10, 0.1, 0.2, 1.2)
hmod.atan.exp(x, 0.1, 0.2, 1.2)

# Data
x <- bladder
# ML estimates
params = list(alpha=0.04599, beta=0.14935, lambda=1.23266)
#P–P (probability–probability) plot
pp.plot(x, params = params, pfun = pmod.atan.exp, fit.line=TRUE)

#Q-Q (quantile–quantile) plot 
qq.plot(x, params = params, qfun = qmod.atan.exp, fit.line=TRUE)

# Goodness-of-Fit(GoF) and Model Diagnostics 
out <- gofic(x, params = params,
             dfun = dmod.atan.exp, pfun=pmod.atan.exp, plot=FALSE)
print.gofic(out)

}
\references{
Chaudhary, A.K., Telee, L.B.S., & Kumar, V.(2023). 
Modified Arctan Exponential Distribution with application to COVID-19 
Second Wave data in Nepal. \emph{Journal of Econometrics and Statistics}, 
\bold{4(1)}, 63--78.
}
