% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LogisExpPower.r
\name{LogisExpPower}
\alias{LogisExpPower}
\alias{dlogis.exp.power}
\alias{plogis.exp.power}
\alias{qlogis.exp.power}
\alias{rlogis.exp.power}
\alias{hlogis.exp.power}
\title{Logistic-Exponential Power (LEP) Distribution}
\usage{
dlogis.exp.power(x, alpha, beta, lambda, log = FALSE)
plogis.exp.power(q, alpha, beta, lambda, lower.tail = TRUE, log.p = FALSE)
qlogis.exp.power(p, alpha, beta, lambda, lower.tail = TRUE, log.p = FALSE)
rlogis.exp.power(n, alpha, beta, lambda)
hlogis.exp.power(x, alpha, beta, lambda)
}
\arguments{
\item{x, q}{numeric vector of quantiles (x, q)}

\item{alpha}{positive numeric parameter}

\item{beta}{positive numeric parameter}

\item{lambda}{positive numeric parameter}

\item{log}{logical; if TRUE, returns log-density}

\item{lower.tail}{logical; if TRUE (default), probabilities are 
\eqn{P[X \le x]} otherwise, \eqn{P[X > x]}.}

\item{log.p}{logical; if TRUE, probabilities are given as log(p)}

\item{p}{numeric vector of probabilities (0 < p < 1)}

\item{n}{number of observations (integer > 0)}
}
\value{
\itemize{
  \item \code{dlogis.exp.power}: numeric vector of (log-)densities
  \item \code{plogis.exp.power}: numeric vector of probabilities
  \item \code{qlogis.exp.power}: numeric vector of quantiles
  \item \code{rlogis.exp.power}: numeric vector of random variates
  \item \code{hlogis.exp.power}: numeric vector of hazard values
}
}
\description{
Provides density, distribution, quantile, random generation,
and hazard functions for the Logistic-Exponential Power distribution.
}
\details{
The Logistic-Exponential Power distribution is parameterized by the parameters
\eqn{\alpha > 0}, \eqn{\beta > 0}, and \eqn{\lambda > 0}.


The Logistic-Exponential Power distribution has CDF:

\deqn{
F(x; \alpha, \beta, \lambda) =
\quad 1-\frac{1}{1+\left\{\exp \left(e^{\lambda x^\beta}-1\right)-1\right\}^\alpha}   ; x \geq 0.
}

where \eqn{\alpha}, \eqn{\beta}, and \eqn{\lambda} are the parameters.

The implementation includes the following functions:
\itemize{
  \item \code{dlogis.exp.power()} — Density function
  \item \code{plogis.exp.power()} — Distribution function
  \item \code{qlogis.exp.power()} — Quantile function
  \item \code{rlogis.exp.power()} — Random generation
  \item \code{hlogis.exp.power()} — Hazard function
}
}
\examples{
x <- seq(0.1, 2.0, 0.1)
dlogis.exp.power(x, 1.5, 1.5, 0.1)
plogis.exp.power(x, 1.5, 1.5, 0.1)
qlogis.exp.power(0.5, 1.5, 1.5, 0.1)
rlogis.exp.power(10, 2.0, 5.0, 0.1)
hlogis.exp.power(x, 1.5, 1.5, 0.1)

# Data
x <- stress
# ML estimates
params = list(alpha=1.8940, beta=1.2276, lambda=0.1650)
#P–P (probability–probability) plot
pp.plot(x, params = params, pfun = plogis.exp.power, fit.line=TRUE)

#Q-Q (quantile–quantile) plot 
qq.plot(x, params = params, qfun = qlogis.exp.power, fit.line=TRUE)

# Goodness-of-Fit(GoF) and Model Diagnostics 
out <- gofic(x, params = params,
             dfun = dlogis.exp.power, pfun=plogis.exp.power, plot=FALSE)
print.gofic(out)

}
\references{
Joshi, R. K., Sapkota, L.P., & Kumar, V. (2020). 
The Logistic-Exponential Power Distribution with Statistical Properties 
and Applications. \emph{International Journal of Emerging Technologies 
and Innovative Research}, \bold{7(12)}, 629--641.
}
