% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExpoExpPower.r
\name{ExpoExpPower}
\alias{ExpoExpPower}
\alias{dgen.exp.power}
\alias{pgen.exp.power}
\alias{qgen.exp.power}
\alias{rgen.exp.power}
\alias{hgen.exp.power}
\title{Exponentiated Exponential Power (EEP) Distribution}
\usage{
dgen.exp.power(x, alpha, lambda, theta, log = FALSE)
pgen.exp.power(q, alpha, lambda, theta, lower.tail = TRUE, log.p = FALSE)
qgen.exp.power(p, alpha, lambda, theta, lower.tail = TRUE, log.p = FALSE)
rgen.exp.power(n, alpha, lambda, theta)
hgen.exp.power(x, alpha, lambda, theta)
}
\arguments{
\item{x, q}{numeric vector of quantiles (x, q)}

\item{alpha}{positive numeric parameter}

\item{lambda}{positive numeric parameter}

\item{theta}{positive numeric parameter}

\item{log}{logical; if TRUE, returns log-density}

\item{lower.tail}{logical; if TRUE (default), probabilities are 
\eqn{P[X \le x]} otherwise, \eqn{P[X > x]}.}

\item{log.p}{logical; if TRUE, probabilities are given as log(p)}

\item{p}{numeric vector of probabilities (0 < p < 1)}

\item{n}{number of observations (integer > 0)}
}
\value{
\itemize{
  \item \code{dgen.exp.power}: numeric vector of (log-)densities
  \item \code{pgen.exp.power}: numeric vector of probabilities
  \item \code{qgen.exp.power}: numeric vector of quantiles
  \item \code{rgen.exp.power}: numeric vector of random variates
  \item \code{hgen.exp.power}: numeric vector of hazard values
}
}
\description{
Provides density, distribution, quantile, random generation,
and hazard functions for the Exponentiated Exponential Power (EEP) distribution.
}
\details{
The EEP distribution is parameterized by the parameters
\eqn{\alpha > 0}, \eqn{\lambda > 0}, and \eqn{\theta > 0}.


The Exponentiated Exponential Power (EEP) distribution has CDF:

\deqn{
F(x;\,\alpha ,\;\lambda ,\theta ) = {\left[ 
{1 - \exp \left\{ {1 - \exp \left( {\lambda {x^\alpha }} \right)} \right\}}
 \right]^\theta }\;\;\;;\;\;x > 0
}

where \eqn{\alpha}, \eqn{\lambda}, and \eqn{\theta} are the parameters.

The implementation includes the following functions:
\itemize{
  \item \code{dgen.exp.power()} — Density function
  \item \code{pgen.exp.power()} — Distribution function
  \item \code{qgen.exp.power()} — Quantile function
  \item \code{rgen.exp.power()} — Random generation
  \item \code{hgen.exp.power()} — Hazard function
}
}
\examples{
x <- seq(0.1, 1, 0.1)
dgen.exp.power(x, 1.5, 0.8, 2)
pgen.exp.power(x, 1.5, 0.8, 2)
qgen.exp.power(0.5, 1.5, 0.8, 2)
rgen.exp.power(10, 1.5, 0.8, 2)
hgen.exp.power(x, 1.5, 0.8, 2)
#Data
x <- waiting
#ML Estimates    
params = list(alpha=0.3407, lambda=0.6068, theta=7.6150)
#P–P (probability–probability) plot
pp.plot(x, params = params, pfun = pgen.exp.power, fit.line=TRUE)

#Q-Q (quantile–quantile) plot 
qq.plot(x, params = params, qfun = qgen.exp.power, fit.line=TRUE)

# Goodness-of-Fit(GoF) and Model Diagnostics 
# Neither plot nor console output; results stored in 'out'
out <- gofic(x, params = params,
             dfun = dgen.exp.power, pfun = pgen.exp.power, plot=FALSE)
print.gofic(out)

}
\references{
Sapkota, L.P., & Kumar, V.(2024).  
Bayesian Analysis of Exponentiated Exponential Power Distribution under 
Hamiltonian Monte Carlo Method, Statistics and Applications. 
\emph{Statistics and Applications}, \bold{22(2)}, 231--258.

Srivastava, A.K., & Kumar, V.(2011). 
Analysis of Software Reliability Data using Exponential Power Model. 
\emph{International Journal of Advanced Computer Science and Applications}, 
\bold{2(2)}, 38--45, \doi{10.14569/IJACSA.2011.020208}
	
Chen, Z.(1999). Statistical inference about the shape parameter of 
the exponential power distribution, \emph{Statistical Papers}, \bold{40}, 459--468.
	
Smith, R.M., & Bain, L.J. (1975). 
An exponential power life-test distribution. 
\emph{IEEE Communications in Statistics}, \bold{4}, 469--481.
}
