% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NetworkStatic.R
\name{NetworkStatic}
\alias{NetworkStatic}
\title{Degree-corrected multilinear tensor model}
\usage{
NetworkStatic(
  Y,
  R = 2,
  mcmc = 100,
  burnin = 100,
  verbose = 0,
  thin = 1,
  reduce.mcmc = NULL,
  degree.normal = "eigen",
  UL.Normal = "Orthonormal",
  plotUU = FALSE,
  plotZ = FALSE,
  constant = FALSE,
  b0 = 0,
  B0 = 1,
  c0 = NULL,
  d0 = NULL,
  u0 = NULL,
  u1 = NULL,
  v0 = NULL,
  v1 = NULL,
  marginal = FALSE,
  DIC = FALSE,
  Waic = FALSE
)
}
\arguments{
\item{Y}{Reponse tensor}

\item{R}{Dimension of latent space. The default is 2.}

\item{mcmc}{The number of MCMC iterations after burnin.}

\item{burnin}{The number of burn-in iterations for the sampler.}

\item{verbose}{A switch which determines whether or not the progress of the
sampler is printed to the screen.  If \code{verbose} is greater than 0 the
iteration number, the \eqn{\beta} vector, and the error variance are
printed to the screen every \code{verbose}th iteration.}

\item{thin}{The thinning interval used in the simulation.  The number of
MCMC iterations must be divisible by this value.}

\item{reduce.mcmc}{The number of reduced MCMC iterations for marginal likelihood computations.
If \code{reduce.mcmc = NULL}, \code{mcmc/thin} is used.}

\item{degree.normal}{A null model for degree correction. Users can choose "NULL", "eigen" or "Lsym."
"NULL" is no degree correction. "eigen" is a principal eigen-matrix consisting of
the first eigenvalue and the corresponding eigenvector. "
Lsym" is a modularity matrix. Default is "eigen."}

\item{UL.Normal}{Transformation of sampled U. Users can choose "NULL", "Normal" or "Orthonormal."
"NULL" is no normalization. "Normal" is the standard normalization.
"Orthonormal" is the Gram-Schmidt orthgonalization. Default is "NULL."}

\item{plotUU}{If \code{plotUU = TRUE} and \code{verbose > 0},
then the plot of the latent space will be
printed to the screen at every \code{verbose}th iteration.
The default is \code{plotUU = FALSE}.}

\item{plotZ}{If \code{plotZ = TRUE} and \code{verbose > 0},
then the plot of the degree-corrected input matrix will be
printed to the screen with the sampled mean values at every \code{verbose}th iteration.
The default is \code{plotUU = FALSE}.}

\item{constant}{If \code{constant = TRUE}, constant parameter is sampled
and saved in the output as attribute \code{bmat}. Default is \code{constant = FALSE}.}

\item{b0}{The prior mean of \eqn{\beta}. This must be a scalar. The default value is 0.}

\item{B0}{The prior variance of \eqn{\beta}. This must be a scalar.  The default value is 1.}

\item{c0}{= 0.1}

\item{d0}{= 0.1}

\item{u0}{\eqn{u_0/2} is the shape parameter for the inverse
Gamma prior on variance parameters for U. The default is 10.}

\item{u1}{\eqn{u_1/2} is the scale parameter for the
inverse Gamma prior on variance parameters for U.
The default is 1.}

\item{v0}{\eqn{v_0/2} is the shape parameter for the inverse
Gamma prior on variance parameters for V.
The default is 10.}

\item{v1}{\eqn{v_1/2} is the scale parameter for the
inverse Gamma prior on variance parameters for V.
The default is the time length of Y.}

\item{marginal}{If \code{marginal = TRUE}, the log marignal likelihood is computed using the method of Chib (1995).}

\item{DIC}{If \code{DIC = TRUE}, the deviation information criterion is computed.}

\item{Waic}{If \code{Waic = TRUE}, the Watanabe information criterion is computed.}
}
\value{
An mcmc object that contains the posterior sample. This object can
be summarized by functions provided by the coda package.  The object
contains an attribute \code{Waic.out} that contains results of WAIC and the log-marginal
likelihood of the model (\code{logmarglike}).
}
\description{
NetworkStatic implements a degree-corrected Bayesian multilinear tensor decomposition method
}
\examples{

   \dontrun{
   set.seed(1973)

   \## generate an array with three constant blocks
   Y <- MakeBlockNetworkChange(n=10, shape=10, T=10, type ="constant")
   G <- 100 ## Small mcmc scans to save time
   out0 <- NetworkStatic(Y, R=2, mcmc=G, burnin=G, verbose=G)

   \## recovered latent blocks
   Kmeans(out0, n.cluster=3, main="Recovered Blocks")

   \## contour plot of latent node positions
   plotContour(out0)

   \## plot latent node positions
   plotU(out0)

   \## plot layer-specific network connection rules
   plotV(out0)
   }

}
\references{
Jong Hee Park and Yunkyun Sohn. 2020. "Detecting Structural Change
in Longitudinal Network Data." \emph{Bayesian Analysis}. Vol.15, No.1, pp.133-157.

Peter D. Hoff 2011. "Hierarchical Multilinear Models for Multiway Data."
\emph{Computational Statistics & Data Analysis}. 55: 530-543.

Sumio Watanabe. 2010. "Asymptotic equivalence of Bayes cross validation and widely
applicable information criterion in singular learning theory."
\emph{Journal of Machine Learning Research}. 11: 3571-3594.
Siddhartha Chib. 1995. ``Marginal Likelihood from the Gibbs Output.''
\emph{Journal of the American Statistical Association}. 90: 1313-1321.
}
\seealso{
\code{\link{NetworkChange}}
}
