% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecological_indices.R
\name{cal.J}
\alias{cal.J}
\alias{cal.J.data.frame}
\alias{cal.J.matrix}
\alias{cal.J.default}
\title{Calculate Pielou's Evenness Index (J)}
\usage{
cal.J(data, ...)

\method{cal.J}{data.frame}(data, ...)

\method{cal.J}{matrix}(data, ...)

\method{cal.J}{default}(data, ...)
}
\arguments{
\item{data}{\code{data.frame} or \code{matrix}. The nematode abundance table where rows represent samples and columns represent nematode genera.
Each element indicates the count of a specific nematode genus in the corresponding sample. Row names must be sample names, and column names must be nematode genus names.}

\item{...}{Additional arguments (currently unused).}
}
\value{
A data frame with two columns:
\item{Sample.ID}{Character vector of sample identifiers (from row names of \code{data})}
\item{J}{Pielou's Evenness Index for each sample}
}
\description{
This function calculates the Pielou's Evenness Index (J) for ecological communities.
}
\examples{
# Example with a data frame
df <- data.frame(
  Cephalobus = c(10, NA, 15),
  Caenorhabditis = c(5, 10, NA),
  Pratylenchus = c(8, 12, 10),
  row.names = c("A", "B", "C")
)
cal.J(data = df)
}
