% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc.bin.prob.B.R
\name{calc.bin.prob.B}
\alias{calc.bin.prob.B}
\title{Collapse binomial data outcomes to binary variable}
\usage{
calc.bin.prob.B(B.n.vec, B.prob.vec)
}
\arguments{
\item{B.n.vec}{Numeric vector of trial counts for each variable}

\item{B.prob.vec}{Numeric vector of success probabilities for each variable}
}
\value{
A list containing the binary probability vector, the list of binomial probability mass functions for each variable, and the corresponding threshold indices
}
\description{
This function computes the binary probability and identifies a threshold
to split discrete binomial outcomes. It summarizes each binomial distribution by
providing the probability mass function, the probability of exceeding a median-based threshold,
and the location of the threshold for the binary split.
}
\examples{
B.n.vec <- c(3, 4, 5)
B.prob.vec <- c(0.5, 0.5, 0.5)
p <- calc.bin.prob.B(B.n.vec, B.prob.vec)

}
