% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixmashnet-print.R
\name{print.mixmashnet}
\alias{print.mixmashnet}
\title{Print method for MixMashNet objects}
\usage{
\method{print}{mixmashnet}(x, ...)
}
\arguments{
\item{x}{An object of class \code{mixmashnet}, returned by
\code{mixMN()} or \code{multimixMN()}.}

\item{...}{Additional arguments.}
}
\value{
The input object \code{x}, returned invisibly.
}
\description{
Compact textual summary for objects returned by \code{mixMN()} and
\code{multimixMN()}. The method reports:
\itemize{
  \item whether the fit is single layer (\code{mixMN}) or multilayer
        (\code{multimixMN});
  \item number of subjects (if available) and variables;
  \item for multilayer fits, the number of nodes and non-zero edges per layer
        and, if present, per interlayer pair;
  \item size of the global graph (nodes and edges);
  \item number of communities (single layer) or communities per layer
        (multilayer);
  \item covariates used for adjustment and nodes excluded from the graph
        and/or clustering;
  \item main settings for community detection and bootstrap;
  \item data info.
}
}
\seealso{
\code{\link{mixMN}}, \code{\link{multimixMN}}
}
