#' NHGH dataset
#'
#' @description
#' Example dataset used in MixMashNet examples. This dataset contains 15 variables
#' derived from the National Health and Nutrition Examination Survey (NHANES)
#'
#' @docType data
#' @name nhgh_data
#' @usage data(nhgh_data)
#' @format A data frame with 5621 rows and 15 variables:
#' \describe{
#'   \item{wt}{Weight (numeric).}
#'   \item{ht}{Height (numeric).}
#'   \item{bmi}{Body mass index (numeric).}
#'   \item{leg}{Leg length (numeric).}
#'   \item{arml}{Arm length (numeric).}
#'   \item{armc}{Arm circumference (numeric).}
#'   \item{tri}{Triceps skinfold (numeric).}
#'   \item{sub}{Subscapular skinfold (numeric).}
#'   \item{gh}{Glychohemoglobin (numeric).}
#'   \item{albumin}{Albumin (numeric).}
#'   \item{bun}{Blood urea nitrogen (numeric).}
#'   \item{SCr}{Serum creatinine (numeric).}
#'   \item{age}{Age (numeric).}
#'   \item{sex}{Sex with 0=woman and 1=man.}
#'   \item{re}{Race with 1=Mexican American, 2=Other Hispanic, 3=Non-Hispanic White, 4=Non-Hispanic Black, 5=Other Race Including Multi-Racial.}
#' }
#'
#' @references
#'
#' Centers for Disease Control and Prevention (CDC) & National Center for Health
#' Statistics (NCHS). (2020).
#' National Health and Nutrition Examination Survey data.
#' \url{https://www.cdc.gov/nchs/nhanes/}
NULL
