\name{MaxInt.heatmap.plot}
\alias{MaxInt.heatmap.plot}
\title{
Heatmap for Visualizing Row by Column (Participant-by-Task) Clusters Interaction
}
\description{
This function generates a heatmap to visualize the estimated interaction values (\eqn{\Gamma}) between row clusters (e.g., participant groups) and column clusters (e.g., task groups) 
obtained from the maximal interaction two-mode clustering approach (REMAXINT and/or E-ReMI).
}
\usage{
MaxInt.heatmap.plot(Gamma_matrix, row_counts = NULL)
}
\arguments{
  \item{Gamma_matrix}{
A numeric matrix containing the estimated interaction values (\eqn{\Gamma}) for each combination of row and column clusters. Rows represent participant clusters and columns represent task clusters.
}
  \item{row_counts}{
An optional numeric vector indicating the number of participants in each row cluster. If provided, these counts are displayed in the plot caption.
}
}
\details{
The function converts the \code{Gamma_matrix} into a long format and visualizes it as a heatmap using \code{ggplot2}. The heatmap tiles are colored based on the magnitude of the estimated \eqn{\Gamma} values, 
and the corresponding values are displayed within the tiles.  

If \code{row_counts} is provided, the counts for each row cluster are displayed in the plot caption to provide additional context on cluster sizes.
}
\value{
Returns a \code{ggplot} object containing the heatmap visualization. The plot includes:
\itemize{
  \item Heatmap tiles filled based on the \eqn{\Gamma} values.
  \item Numeric labels inside each tile showing the rounded \eqn{\Gamma} value.
  \item Optional caption with participant counts for each row cluster.
}
}
\references{
Ahmed, Z., van Breukelen, G. J. P., Schepers, J., & Cassese, A. (2025). Robustness study of normality-based likelihood ratio tests 
for testing maximal interaction two-mode clustering and a permutation based alternative. \emph{Available on OSF} 
(submitted to Advances in Data Analysis and Classification).
Ahmed, Z., van Breukelen, G. J. P., Schepers, J., & Cassese, A. (2023). E-ReMI: extended maximal interaction two-mode clustering. 
\emph{Journal of Classification, 40,  298-331}
Ahmed, Z., van Breukelen, G. J. P., Schepers, J., & Cassese, A. (2021). REMAXINT: a two-mode clustering-based method for statistical
inference on two-way interaction. \emph{Advances in Data Analysis and Classification, 15(4), 987-1013}
}
\author{
Zaheer Ahmed (ahmed@ifado.de), 
Jan Schepers (jan.schepers@maastrichtuniversity.nl), 
Uwe Ligges (ligges@statistik.tu-dortmund.de), 
Alberto Cassese (alberto.cassese@unifi.it), 
Gerard van Breukelen (gerard.vbreukelen@maastrichtuniversity.nl), 
Katja Ickstadt (ickstadt@statistik.tu-dortmund.de), 
Edmund Wascher (wascher@ifado.de)
}
\note{
This function is intended to be used after obtaining \eqn{\Gamma} matrices from the \code{MaxInt_data_analysis} function.
}
\seealso{
\code{\link{MaxInt_data_analysis}}, \code{\link{MaxInteraction.plot}}, \code{\link{screeplot.MaxInt_data_analysis}}
}
\examples{
Gamma_matrix <- matrix(c(0.3, -0.2, 0.5, 0.1, 0.4, -0.1), nrow = 2, byrow = TRUE)
rownames(Gamma_matrix) <- c("Cluster 1", "Cluster 2")
colnames(Gamma_matrix) <- c("Task A", "Task B", "Task C")
MaxInt.heatmap.plot(Gamma_matrix, row_counts = c(50, 40))
}
\keyword{visualization}
\keyword{bi-clustering}
\keyword{REMAXINT and E-ReMI}
