#' Assembly function: Logarithmic-one-minus function
#'
#' This function evaluates the logarithmic-one-minus function \deqn{f(x_1,x_2,\ldots,x_k)=\log(1-\sum_{i=1}^kc_ix_{i})} where \eqn{\sum_{i=1}^kc_ix_{i}\in(0,1)}.
#'
#' @param parameter The value of the parameters \eqn{x_1,x_2,\ldots,x_k}.
#' @param coefficient The value of the coefficients \eqn{c_1,c_2,\ldots,c_k}.
#'
#' @return
#' Value of the logarithmic-one-minus function.
#'
#' @keywords internal
#' @noRd
Logarithmic_one_minus<-function(parameter,coefficient)
{
  return(log(1-sum(coefficient*parameter)))
}
