% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_morphospace.R
\name{create_morphospace}
\alias{create_morphospace}
\title{Create a morphospace of predictor combinations with class probabilities}
\usage{
create_morphospace(the_data, model, shiny = FALSE)
}
\arguments{
\item{the_data}{A data.frame used to derive unique values of predictors.}

\item{model}{A classification model fitted via a formula interface that
supports \code{predict(model, newdata, type = "prob")}
(e.g., from \link{create_rf_model}).}

\item{shiny}{Logical; if \code{TRUE}, compute predictions in batches with
\pkg{shiny} progress. Default \code{FALSE}.}
}
\value{
A list with components:
\itemize{
\item \code{morphospace}: data frame with all predictor combinations,
class label column (named as the dependent), \code{calculated} (probability),
and \code{purely_simulated} flag.
\item \code{dependent}: character scalar with the outcome name.
\item \code{independent}: character vector of predictor names.
\item \code{all_vars}: character vector \code{c(independent, dependent)}.
\item \code{purely_simulated}: logical vector aligned with \code{morphospace}.
}
}
\description{
Create a morphospace of predictor combinations with class probabilities
}
\examples{
n  <- 60
y  <- factor(sample(letters[1:3], n, TRUE))
x1 <- factorize_numeric_vector(runif(n, 10, 20), breaks_no = 3)
x2 <- factorize_numeric_vector(runif(n,  1,  2), breaks_no = 3)
df <- data.frame(y, x1, x2)
fit <- create_rf_model(df, dependent = "y", ntree = 50)$model
ms  <- create_morphospace(df, fit)
names(ms)
}
