% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/performance_optimalization.R
\name{create_sparse_comat}
\alias{create_sparse_comat}
\title{Create a sparse co-occurrence matrix}
\usage{
create_sparse_comat(
  entity_data,
  doc_id_col = "doc_id",
  entity_col = "entity",
  count_col = NULL,
  type_col = NULL,
  normalize = TRUE
)
}
\arguments{
\item{entity_data}{A data frame with document IDs and entities.}

\item{doc_id_col}{Name of the column containing document IDs.}

\item{entity_col}{Name of the column containing entity names.}

\item{count_col}{Name of the column containing entity counts (optional).}

\item{type_col}{Name of the column containing entity types (optional).}

\item{normalize}{Logical. If TRUE, normalizes the co-occurrence matrix.}
}
\value{
A sparse matrix of entity co-occurrences.
}
\description{
This function creates a sparse co-occurrence matrix from entity data,
which is more memory-efficient for large datasets.
}
